
library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 
  

entity tm_tb is
end entity tm_tb;

architecture arch of tm_tb is
	signal clk_tb:std_logic:='0';
	signal cicdata1_tb:std_logic;
	signal cicdata2_tb:std_logic;
	signal pdm_data_mux_tb:std_logic;

		component timemux is 
		port( 
			clk:in std_logic;
      			cicdata1: in std_logic;
	  		cicdata2:in std_logic;
			pdm_data_mux:out std_logic);
		end component timemux;

begin 
		timemux1_component:
		component timemux
			port map( 
			clk=>clk_tb,
 	     		cicdata1=>cicdata1_tb ,
		  	cicdata2=>cicdata2_tb,
			pdm_data_mux=>pdm_data_mux_tb);
		

  	clkproc:
		process
			begin
			Wait for 50 ns;
			clk_tb<=not(clk_tb);
		end process; 

		cicdata1_tb<= '0',
			'1' after 500 ns,
			'1' after 1000 ns;
		cicdata2_tb<='1',
				'0' after 500 ns,
				'0' after 1000 ns;

    test_proc:
		process
			begin
			wait for 50 ns;
			assert( pdm_data_mux_tb= '0')
			report "incorrect result"
			severity error;
			
			wait for 450 ns; --500 ns
			assert( pdm_data_mux_tb= '0')
			report "incorrect result"
			severity error;

			wait for 500 ns; -- 1000 ns
			assert( pdm_data_mux_tb= '0')
			report "incorrect result"
			severity error;
		end process;
end architecture arch;
			
			
			
			